// AObufferDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AObuffer.h"
#include "AObufferDlg.h"
#include<math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAObufferDlg dialog

CAObufferDlg::CAObufferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAObufferDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAObufferDlg)
	m_deviceNumber = 0;
	m_statusLabel = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAObufferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAObufferDlg)
	DDX_Control(pDX, IDC_QUIT, m_quitEn);
	DDX_Control(pDX, IDC_STOP, m_stopEn);
	DDX_Control(pDX, IDC_START, m_startEn);
	DDX_Text(pDX, IDC_DEVICE_NUMBER, m_deviceNumber);
	DDV_MinMaxInt(pDX, m_deviceNumber, 0, 5);
	DDX_Text(pDX, IDC_STATUSBOX, m_statusLabel);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAObufferDlg, CDialog)
	//{{AFX_MSG_MAP(CAObufferDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_INITIALIZE, OnInitializeDriverLINX)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAObufferDlg message handlers

BOOL CAObufferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// set our pointers equal to something
	m_pSR = NULL;
	m_driverInstance = NULL;
	m_deviceNumber = 0;  // give initial value to our dialog item
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAObufferDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAObufferDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAObufferDlg::showMessage(DL_ServiceRequest* SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
}

void CAObufferDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	clearBuffers();
	if (m_pSR != NULL)
	{ 	delete m_pSR;
		m_pSR=NULL;
	}
			if (m_driverInstance != NULL)
			{
	           CloseDriverLINX(m_driverInstance);
	           m_driverInstance=NULL;
			}
	OnOK();
	
}

void CAObufferDlg::OnStart() 
{
	/*This sets up two tasks:
	1.  one to convert the floating point data into a native format for the 
	    analog output DACs (12 or 16bit counts).  The CONVERT operation also moves
		the data into a memory buffer that DriverLINX will use in task 2

	2.  the second sets up the analog output service to generate a sine wave.
	*/
	
	
	//memset(m_pSR,0,sizeof(DL_ServiceRequest));
	//DL_SetServiceRequestSize(*m_pSR);
	
	// generate some voltage data for the DAC to write
	WORD SampleNum=100;  // nSamples
	
	float sinebuf[100]; //create an array of float for the sine wave
	DWORD i;
	for(i=0;i<100;i++)
	{
		sinebuf[i]=(float)sin(i*2*3.14159/(100))*5;  // 5 volt amplitude,100 points per period,1 cycles
	}  

    clearBuffers(); //clear any existing memory buffers

	// now allocate buffer to hold our data
	m_pSR->lpBuffers=(DL_BUFFERLIST*)new BYTE[DL_BufferListBytes(1)]; //Create a buffer list for 1 buffers
	m_pSR->lpBuffers->nBuffers=1; //One buffer will be used
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(m_deviceNumber,AO,m_logicalChannel,SampleNum); //allocate enough bytes for the samples
    m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_DMA16,m_pSR->lpBuffers->bufferSize); //allocate one buffer
    
	
	/* now use CONVERT operation to convert volts to counts according to hardware
	   feature of the DAC, e.g. 12 or 16 bit and offset binary, etc. AND to move this
	   data from the sinebuf array to the allocated memory buffer  */
	m_pSR->hWnd=m_hWnd;
	m_pSR->operation=CONVERT; //Use the convert operation to translate float into counts
	m_pSR->device=m_deviceNumber;
	m_pSR->subsystem=AO;
	m_pSR->mode=OTHER;
	m_pSR->channels.nChannels=1;  //only using one channel
	m_pSR->channels.chanGain[0].channel=m_logicalChannel; // Set the appropriate channel in the channel/gain list
	m_pSR->channels.numberFormat=tNATIVE;
	m_pSR->start.typeEvent=DATACONVERT;
	m_pSR->start.u.dataConvert.nSamples = SampleNum; //nSamples to Convert
    m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //the input buffer is of type float
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=0; //put the converted samples into buffer 0
	m_pSR->start.u.dataConvert.lpBuffer=sinebuf; //use the sinebuf array as the data
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 for the conversion
	DriverLINX(m_pSR); //execute the conversion
	showMessage(m_pSR); //show any errors

		/*   convert operation is size limited to 2^16 Samples (65535) (WORD)    */

	

	/* Now Setup the service request for DMA mode analog output
	  Now that data are in the memory buffers, program a paced mode
	  AO task to write this data on the DAC at a requested update rate*/
	
	m_pSR->operation=START;
	m_pSR->device=m_deviceNumber;
	m_pSR->subsystem=AO;
	m_pSR->mode=DMA;
	m_pSR->start.typeEvent=COMMAND;
	m_pSR->stop.typeEvent= COMMAND;  // stop only when a STOP operation is executed
	m_pSR->channels.nChannels=1;  //only using one DAC channel
	m_pSR->channels.chanGain[0].channel=m_logicalChannel; // Set the appropriate channel in the channel/gain list
	m_pSR->channels.numberFormat=tNATIVE;
	m_pSR->lpBuffers->notify=NULL;  // do not post buffer filled messages to be in recycle mode
	m_pSR->timing.typeEvent=RATEEVENT;
	m_pSR->timing.u.rateEvent.channel=DEFAULTTIMER; //DEFAULTTIMER will pick the appropriate timing channel for a rate event
	m_pSR->timing.u.rateEvent.mode=RATEGEN; //use the rate generator mode to time the waveform
	m_pSR->timing.u.rateEvent.clock=INTERNAL1;  // the board's 20MHz internal timebase
	m_pSR->timing.u.rateEvent.gate=DISABLED; //can't use gating 
	m_pSR->timing.u.rateEvent.period=Sec2Tics(m_deviceNumber,AO,INTERNAL1,0.000002f); //500KHz update rate
	                                                              // reduce to 250KHz for KPCI-3116
	/*
         How fast will the resulting sine wave on the DAC be?
		 DAC update rate is 500KHz, and the 100 point buffer contains 1 cycle.
		 Each cycle will be written in 200usec.  This is a 5000 Hz Sine wave

         To accomplish a different freq of sine wave change the combination of:  DAC update rate OR
		 the number of points per cycle.

         Theoritical limit:  DAC update rate of 500KHz (KPCI-3110) writing a Square Wave
		 that uses two points to comprise a period.  Resulting Square Wave will be 250KHz.
		 
		 You can not get a waveform whos freq is equal to the DAC update rate;  the waveform
		 is always comprised of two or more points.
    */

    /*  What is upper limit on update rate?  In recycle mode it speced as 500K for
	    KPCI-3110 or 200KHz for KPCI-3116.  To access recycle mode (buffer wrap mode)
		the service request must:
		     1. use only one buffer
			 2. number of samples is size of FIFO or smaller
			 3. use a DMA or INTERRUPT mode AO task
			 4. do not use buffer notification

		If not using recylce mode, It is computer dependent.  The DAC FIFO of 
	    KPCI-3110 or KPCI-3116 are only used when recycle mode is accessed. When buffers
		of AO data are streamed to the DACs, then the PC must be able to stream the data
		fast enough to prevent underflow (Data Lost) errors.  On P3-933MHz, upper limit on
		rate is about 325KHz.

    */


	m_pSR->timing.u.rateEvent.pulses=0; //the rate generator will be continuous
	
	if (DriverLINX(m_pSR) == NoErr)
	{
	  m_stopEn.EnableWindow(TRUE); //Enable the stop button, but disable the others to avoid conflicts
	  m_startEn.EnableWindow(FALSE);
	  m_quitEn.EnableWindow(FALSE);
	UpdateData(FALSE);
	}
	else
	{  showMessage(m_pSR); }//show any errors
	
}


void CAObufferDlg::clearBuffers()
{
	    if(m_pSR!=NULL)
		{
		if(m_pSR->lpBuffers!=NULL)
		{
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
				{   BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				    m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			
			delete(m_pSR->lpBuffers);
			m_pSR->lpBuffers=NULL;
		}  // lpBuffers != NULL
		}  // of m_pSR != NULL
	
}  // function



void CAObufferDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	m_pSR->operation=STOP; //Request a stop operation to stop the waveform
	DriverLINX(m_pSR); //Execute the stop request
	showMessage(m_pSR);
	m_stopEn.EnableWindow(FALSE); //enable the other buttons, but disable the stop button
	m_startEn.EnableWindow(TRUE);
	m_quitEn.EnableWindow(TRUE);
	UpdateData(FALSE);
	
}

void CAObufferDlg::OnInitializeDriverLINX() 
{
	// read in device number from the dialog
	UpdateData(TRUE);
	
	m_logicalChannel=0; //Set this to the desired channel
//Open the Driver
	m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3100"); 

	m_pSR=(DL_ServiceRequest*) new DL_ServiceRequest;  //create the service request structure
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //reset the members of the service request to defaults
	DL_SetServiceRequestSize(*m_pSR);
	
	// Init the Hardware
	m_pSR->device=m_deviceNumber;
	m_pSR->operation=INITIALIZE;
	m_pSR->subsystem=DEVICE;
	m_pSR->mode=OTHER;
	m_pSR->hWnd=m_hWnd;
	if (DriverLINX(m_pSR) == NoErr)
	{  	// success
	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //need to register DriverLINX messages to detect buffer filled message
	m_startEn.EnableWindow(TRUE);  // enable the Start button
    }
       else  // problem has occured
   {  showMessage(m_pSR);}  // display the error message box

// set focus back to our dialog
CWnd::SetActiveWindow();
}




/*
Step 1:  Open the driver
Step 2:  Init the hardware
Step 3:  Allocate and Load a buffer with data for the DAC
Step 4:  Set up and Start the DMA mode AO task to write the Buffer
Step 5:  Detect DriverLINX messages in message pump to display status of task
Step 6:  Stop any active tasks and close driver, free memory on exit

  Tested with KPCI-3110 with 3100-850A03 in Win2KSP1
*/

LRESULT CAObufferDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// use this message pump to detect messages from DriverLINX

			if(message==m_DLmsg) //Did DriverLINX post a message?  We only want to act on the DriverLINX buffer filled message
	{
		switch(wParam)
		{
		case DL_BUFFERFILLED: //// since in recycle mode, this message will not be sent
			// determine the index of the buffer that if full
			m_bufIndex=getBufIndex(lParam); //Get index of the full buffer
			break;
		case DL_DATALOST:
			// call a handler for this condition
			/*
              if getting data lost, message rate may be too fast...try larger or more buffers
            */
			break;
		case DL_SERVICEDONE:
            m_statusLabel.Format("%s","The task is now inactive.");
			m_stopEn.EnableWindow(FALSE); //Disnable the stop button, but enable the others to avoid conflicts
	        m_startEn.EnableWindow(TRUE);
	        m_quitEn.EnableWindow(TRUE);
	        UpdateData(FALSE); //Update the listbox display
			break;
        case DL_SERVICESTART:
            m_statusLabel.Format("%s","The task has started.");
	        UpdateData(FALSE); //Update the listbox display
			break;
		}
	}
	
	return CDialog::WindowProc(message, wParam, lParam);
}
